
// pybind 11 related includes
#include <pybind11/pybind11.h>
#include <pybind11/stl.h>

namespace py = pybind11;


// Standard Handle
#include <Standard_Handle.hxx>

// user-defined inclusion per module before includes

// includes to resolve forward declarations
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Blend_Point.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Blend_Point.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <gp_Pnt.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Blend_Point.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Blend_Point.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <gp_Pnt.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Blend_Point.hxx>

// module includes
#include <Blend_AppFunction.hxx>
#include <Blend_CSFunction.hxx>
#include <Blend_CurvPointFuncInv.hxx>
#include <Blend_DecrochStatus.hxx>
#include <Blend_FuncInv.hxx>
#include <Blend_Function.hxx>
#include <Blend_Point.hxx>
#include <Blend_RstRstFunction.hxx>
#include <Blend_SequenceOfPoint.hxx>
#include <Blend_Status.hxx>
#include <Blend_SurfCurvFuncInv.hxx>
#include <Blend_SurfPointFuncInv.hxx>
#include <Blend_SurfRstFunction.hxx>

// template related includes

#include "NCollection_tmpl.hxx"


// user-defined pre
#include "OCP_specific.inc"

// user-defined inclusion per module

// Module definiiton
void register_Blend_enums(py::module &main_module) {


py::module m = main_module.def_submodule("Blend", R"#()#");

// add namespaces as submodules

// user-defined inclusion per module in the body

// enums
    py::enum_<Blend_DecrochStatus>(m, "Blend_DecrochStatus",R"#()#")
        .value("Blend_NoDecroch",Blend_DecrochStatus::Blend_NoDecroch)
        .value("Blend_DecrochRst1",Blend_DecrochStatus::Blend_DecrochRst1)
        .value("Blend_DecrochRst2",Blend_DecrochStatus::Blend_DecrochRst2)
        .value("Blend_DecrochBoth",Blend_DecrochStatus::Blend_DecrochBoth).export_values();
    py::enum_<Blend_Status>(m, "Blend_Status",R"#()#")
        .value("Blend_StepTooLarge",Blend_Status::Blend_StepTooLarge)
        .value("Blend_StepTooSmall",Blend_Status::Blend_StepTooSmall)
        .value("Blend_Backward",Blend_Status::Blend_Backward)
        .value("Blend_SamePoints",Blend_Status::Blend_SamePoints)
        .value("Blend_OnRst1",Blend_Status::Blend_OnRst1)
        .value("Blend_OnRst2",Blend_Status::Blend_OnRst2)
        .value("Blend_OnRst12",Blend_Status::Blend_OnRst12)
        .value("Blend_OK",Blend_Status::Blend_OK).export_values();

//Python trampoline classes
    class Py_Blend_AppFunction : public Blend_AppFunction{
    public:
        using Blend_AppFunction::Blend_AppFunction;


        // public pure virtual
        Standard_Integer NbVariables() const  override { using return_type = Standard_Integer;
    PYBIND11_OVERLOAD_PURE(return_type,Blend_AppFunction,NbVariables,) };
        Standard_Integer NbEquations() const  override { using return_type = Standard_Integer;
    PYBIND11_OVERLOAD_PURE(return_type,Blend_AppFunction,NbEquations,) };
        Standard_Boolean Value( const math_Vector & X,math_Vector & F) override { using return_type = Standard_Boolean;
    PYBIND11_OVERLOAD_PURE(return_type,Blend_AppFunction,Value,X,F) };
        Standard_Boolean Derivatives( const math_Vector & X,math_Matrix & D) override { using return_type = Standard_Boolean;
    PYBIND11_OVERLOAD_PURE(return_type,Blend_AppFunction,Derivatives,X,D) };
        Standard_Boolean Values( const math_Vector & X,math_Vector & F,math_Matrix & D) override { using return_type = Standard_Boolean;
    PYBIND11_OVERLOAD_PURE(return_type,Blend_AppFunction,Values,X,F,D) };
        void Set( const Standard_Real Param) override { using return_type = void;
    PYBIND11_OVERLOAD_PURE(return_type,Blend_AppFunction,Set,Param) };
        void Set( const Standard_Real First, const Standard_Real Last) override { using return_type = void;
    PYBIND11_OVERLOAD_PURE(return_type,Blend_AppFunction,Set,First,Last) };
        void GetTolerance(math_Vector & Tolerance, const Standard_Real Tol) const  override { using return_type = void;
    PYBIND11_OVERLOAD_PURE(return_type,Blend_AppFunction,GetTolerance,Tolerance,Tol) };
        void GetBounds(math_Vector & InfBound,math_Vector & SupBound) const  override { using return_type = void;
    PYBIND11_OVERLOAD_PURE(return_type,Blend_AppFunction,GetBounds,InfBound,SupBound) };
        Standard_Boolean IsSolution( const math_Vector & Sol, const Standard_Real Tol) override { using return_type = Standard_Boolean;
    PYBIND11_OVERLOAD_PURE(return_type,Blend_AppFunction,IsSolution,Sol,Tol) };
        Standard_Real GetMinimalDistance() const  override { using return_type = Standard_Real;
    PYBIND11_OVERLOAD_PURE(return_type,Blend_AppFunction,GetMinimalDistance,) };
         const gp_Pnt & Pnt1() const  override { using return_type =  const gp_Pnt &;
    PYBIND11_OVERLOAD_PURE(return_type,Blend_AppFunction,Pnt1,) };
         const gp_Pnt & Pnt2() const  override { using return_type =  const gp_Pnt &;
    PYBIND11_OVERLOAD_PURE(return_type,Blend_AppFunction,Pnt2,) };
        Standard_Boolean IsRational() const  override { using return_type = Standard_Boolean;
    PYBIND11_OVERLOAD_PURE(return_type,Blend_AppFunction,IsRational,) };
        Standard_Real GetSectionSize() const  override { using return_type = Standard_Real;
    PYBIND11_OVERLOAD_PURE(return_type,Blend_AppFunction,GetSectionSize,) };
        void GetMinimalWeight(TColStd_Array1OfReal & Weigths) const  override { using return_type = void;
    PYBIND11_OVERLOAD_PURE(return_type,Blend_AppFunction,GetMinimalWeight,Weigths) };
        Standard_Integer NbIntervals( const GeomAbs_Shape S) const  override { using return_type = Standard_Integer;
    PYBIND11_OVERLOAD_PURE(return_type,Blend_AppFunction,NbIntervals,S) };
        void Intervals(TColStd_Array1OfReal & T, const GeomAbs_Shape S) const  override { using return_type = void;
    PYBIND11_OVERLOAD_PURE(return_type,Blend_AppFunction,Intervals,T,S) };
        void GetTolerance( const Standard_Real BoundTol, const Standard_Real SurfTol, const Standard_Real AngleTol,math_Vector & Tol3d,math_Vector & Tol1D) const  override { using return_type = void;
    PYBIND11_OVERLOAD_PURE(return_type,Blend_AppFunction,GetTolerance,BoundTol,SurfTol,AngleTol,Tol3d,Tol1D) };
        void Knots(TColStd_Array1OfReal & TKnots) override { using return_type = void;
    PYBIND11_OVERLOAD_PURE(return_type,Blend_AppFunction,Knots,TKnots) };
        void Mults(TColStd_Array1OfInteger & TMults) override { using return_type = void;
    PYBIND11_OVERLOAD_PURE(return_type,Blend_AppFunction,Mults,TMults) };
        Standard_Boolean Section( const Blend_Point & P,TColgp_Array1OfPnt & Poles,TColgp_Array1OfVec & DPoles,TColgp_Array1OfPnt2d & Poles2d,TColgp_Array1OfVec2d & DPoles2d,TColStd_Array1OfReal & Weigths,TColStd_Array1OfReal & DWeigths) override { using return_type = Standard_Boolean;
    PYBIND11_OVERLOAD_PURE(return_type,Blend_AppFunction,Section,P,Poles,DPoles,Poles2d,DPoles2d,Weigths,DWeigths) };
        void Section( const Blend_Point & P,TColgp_Array1OfPnt & Poles,TColgp_Array1OfPnt2d & Poles2d,TColStd_Array1OfReal & Weigths) override { using return_type = void;
    PYBIND11_OVERLOAD_PURE(return_type,Blend_AppFunction,Section,P,Poles,Poles2d,Weigths) };
        Standard_Boolean Section( const Blend_Point & P,TColgp_Array1OfPnt & Poles,TColgp_Array1OfVec & DPoles,TColgp_Array1OfVec & D2Poles,TColgp_Array1OfPnt2d & Poles2d,TColgp_Array1OfVec2d & DPoles2d,TColgp_Array1OfVec2d & D2Poles2d,TColStd_Array1OfReal & Weigths,TColStd_Array1OfReal & DWeigths,TColStd_Array1OfReal & D2Weigths) override { using return_type = Standard_Boolean;
    PYBIND11_OVERLOAD_PURE(return_type,Blend_AppFunction,Section,P,Poles,DPoles,D2Poles,Poles2d,DPoles2d,D2Poles2d,Weigths,DWeigths,D2Weigths) };
        void GetShape(Standard_Integer & NbPoles,Standard_Integer & NbKnots,Standard_Integer & Degree,Standard_Integer & NbPoles2d) override { using return_type = void;
    PYBIND11_OVERLOAD_PURE(return_type,Blend_AppFunction,GetShape,NbPoles,NbKnots,Degree,NbPoles2d) };
        void Resolution( const Standard_Integer IC2d, const Standard_Real Tol,Standard_Real & TolU,Standard_Real & TolV) const  override { using return_type = void;
    PYBIND11_OVERLOAD_PURE(return_type,Blend_AppFunction,Resolution,IC2d,Tol,TolU,TolV) };


        // protected pure virtual


        // private pure virtual

    };
    class Py_Blend_CurvPointFuncInv : public Blend_CurvPointFuncInv{
    public:
        using Blend_CurvPointFuncInv::Blend_CurvPointFuncInv;


        // public pure virtual
        Standard_Integer NbEquations() const  override { using return_type = Standard_Integer;
    PYBIND11_OVERLOAD_PURE(return_type,Blend_CurvPointFuncInv,NbEquations,) };
        Standard_Boolean Value( const math_Vector & X,math_Vector & F) override { using return_type = Standard_Boolean;
    PYBIND11_OVERLOAD_PURE(return_type,Blend_CurvPointFuncInv,Value,X,F) };
        Standard_Boolean Derivatives( const math_Vector & X,math_Matrix & D) override { using return_type = Standard_Boolean;
    PYBIND11_OVERLOAD_PURE(return_type,Blend_CurvPointFuncInv,Derivatives,X,D) };
        Standard_Boolean Values( const math_Vector & X,math_Vector & F,math_Matrix & D) override { using return_type = Standard_Boolean;
    PYBIND11_OVERLOAD_PURE(return_type,Blend_CurvPointFuncInv,Values,X,F,D) };
        void Set( const gp_Pnt & P) override { using return_type = void;
    PYBIND11_OVERLOAD_PURE(return_type,Blend_CurvPointFuncInv,Set,P) };
        void GetTolerance(math_Vector & Tolerance, const Standard_Real Tol) const  override { using return_type = void;
    PYBIND11_OVERLOAD_PURE(return_type,Blend_CurvPointFuncInv,GetTolerance,Tolerance,Tol) };
        void GetBounds(math_Vector & InfBound,math_Vector & SupBound) const  override { using return_type = void;
    PYBIND11_OVERLOAD_PURE(return_type,Blend_CurvPointFuncInv,GetBounds,InfBound,SupBound) };
        Standard_Boolean IsSolution( const math_Vector & Sol, const Standard_Real Tol) override { using return_type = Standard_Boolean;
    PYBIND11_OVERLOAD_PURE(return_type,Blend_CurvPointFuncInv,IsSolution,Sol,Tol) };


        // protected pure virtual


        // private pure virtual

    };
    class Py_Blend_FuncInv : public Blend_FuncInv{
    public:
        using Blend_FuncInv::Blend_FuncInv;


        // public pure virtual
        Standard_Integer NbEquations() const  override { using return_type = Standard_Integer;
    PYBIND11_OVERLOAD_PURE(return_type,Blend_FuncInv,NbEquations,) };
        Standard_Boolean Value( const math_Vector & X,math_Vector & F) override { using return_type = Standard_Boolean;
    PYBIND11_OVERLOAD_PURE(return_type,Blend_FuncInv,Value,X,F) };
        Standard_Boolean Derivatives( const math_Vector & X,math_Matrix & D) override { using return_type = Standard_Boolean;
    PYBIND11_OVERLOAD_PURE(return_type,Blend_FuncInv,Derivatives,X,D) };
        Standard_Boolean Values( const math_Vector & X,math_Vector & F,math_Matrix & D) override { using return_type = Standard_Boolean;
    PYBIND11_OVERLOAD_PURE(return_type,Blend_FuncInv,Values,X,F,D) };
        void Set( const Standard_Boolean OnFirst, const handle<Adaptor2d_Curve2d> & COnSurf) override { using return_type = void;
    PYBIND11_OVERLOAD_PURE(return_type,Blend_FuncInv,Set,OnFirst,COnSurf) };
        void GetTolerance(math_Vector & Tolerance, const Standard_Real Tol) const  override { using return_type = void;
    PYBIND11_OVERLOAD_PURE(return_type,Blend_FuncInv,GetTolerance,Tolerance,Tol) };
        void GetBounds(math_Vector & InfBound,math_Vector & SupBound) const  override { using return_type = void;
    PYBIND11_OVERLOAD_PURE(return_type,Blend_FuncInv,GetBounds,InfBound,SupBound) };
        Standard_Boolean IsSolution( const math_Vector & Sol, const Standard_Real Tol) override { using return_type = Standard_Boolean;
    PYBIND11_OVERLOAD_PURE(return_type,Blend_FuncInv,IsSolution,Sol,Tol) };


        // protected pure virtual


        // private pure virtual

    };
    class Py_Blend_SurfCurvFuncInv : public Blend_SurfCurvFuncInv{
    public:
        using Blend_SurfCurvFuncInv::Blend_SurfCurvFuncInv;


        // public pure virtual
        Standard_Integer NbEquations() const  override { using return_type = Standard_Integer;
    PYBIND11_OVERLOAD_PURE(return_type,Blend_SurfCurvFuncInv,NbEquations,) };
        Standard_Boolean Value( const math_Vector & X,math_Vector & F) override { using return_type = Standard_Boolean;
    PYBIND11_OVERLOAD_PURE(return_type,Blend_SurfCurvFuncInv,Value,X,F) };
        Standard_Boolean Derivatives( const math_Vector & X,math_Matrix & D) override { using return_type = Standard_Boolean;
    PYBIND11_OVERLOAD_PURE(return_type,Blend_SurfCurvFuncInv,Derivatives,X,D) };
        Standard_Boolean Values( const math_Vector & X,math_Vector & F,math_Matrix & D) override { using return_type = Standard_Boolean;
    PYBIND11_OVERLOAD_PURE(return_type,Blend_SurfCurvFuncInv,Values,X,F,D) };
        void Set( const handle<Adaptor2d_Curve2d> & Rst) override { using return_type = void;
    PYBIND11_OVERLOAD_PURE(return_type,Blend_SurfCurvFuncInv,Set,Rst) };
        void GetTolerance(math_Vector & Tolerance, const Standard_Real Tol) const  override { using return_type = void;
    PYBIND11_OVERLOAD_PURE(return_type,Blend_SurfCurvFuncInv,GetTolerance,Tolerance,Tol) };
        void GetBounds(math_Vector & InfBound,math_Vector & SupBound) const  override { using return_type = void;
    PYBIND11_OVERLOAD_PURE(return_type,Blend_SurfCurvFuncInv,GetBounds,InfBound,SupBound) };
        Standard_Boolean IsSolution( const math_Vector & Sol, const Standard_Real Tol) override { using return_type = Standard_Boolean;
    PYBIND11_OVERLOAD_PURE(return_type,Blend_SurfCurvFuncInv,IsSolution,Sol,Tol) };


        // protected pure virtual


        // private pure virtual

    };
    class Py_Blend_SurfPointFuncInv : public Blend_SurfPointFuncInv{
    public:
        using Blend_SurfPointFuncInv::Blend_SurfPointFuncInv;


        // public pure virtual
        Standard_Integer NbEquations() const  override { using return_type = Standard_Integer;
    PYBIND11_OVERLOAD_PURE(return_type,Blend_SurfPointFuncInv,NbEquations,) };
        Standard_Boolean Value( const math_Vector & X,math_Vector & F) override { using return_type = Standard_Boolean;
    PYBIND11_OVERLOAD_PURE(return_type,Blend_SurfPointFuncInv,Value,X,F) };
        Standard_Boolean Derivatives( const math_Vector & X,math_Matrix & D) override { using return_type = Standard_Boolean;
    PYBIND11_OVERLOAD_PURE(return_type,Blend_SurfPointFuncInv,Derivatives,X,D) };
        Standard_Boolean Values( const math_Vector & X,math_Vector & F,math_Matrix & D) override { using return_type = Standard_Boolean;
    PYBIND11_OVERLOAD_PURE(return_type,Blend_SurfPointFuncInv,Values,X,F,D) };
        void Set( const gp_Pnt & P) override { using return_type = void;
    PYBIND11_OVERLOAD_PURE(return_type,Blend_SurfPointFuncInv,Set,P) };
        void GetTolerance(math_Vector & Tolerance, const Standard_Real Tol) const  override { using return_type = void;
    PYBIND11_OVERLOAD_PURE(return_type,Blend_SurfPointFuncInv,GetTolerance,Tolerance,Tol) };
        void GetBounds(math_Vector & InfBound,math_Vector & SupBound) const  override { using return_type = void;
    PYBIND11_OVERLOAD_PURE(return_type,Blend_SurfPointFuncInv,GetBounds,InfBound,SupBound) };
        Standard_Boolean IsSolution( const math_Vector & Sol, const Standard_Real Tol) override { using return_type = Standard_Boolean;
    PYBIND11_OVERLOAD_PURE(return_type,Blend_SurfPointFuncInv,IsSolution,Sol,Tol) };


        // protected pure virtual


        // private pure virtual

    };
    class Py_Blend_CSFunction : public Blend_CSFunction{
    public:
        using Blend_CSFunction::Blend_CSFunction;


        // public pure virtual
        Standard_Integer NbEquations() const  override { using return_type = Standard_Integer;
    PYBIND11_OVERLOAD_PURE(return_type,Blend_CSFunction,NbEquations,) };
        Standard_Boolean Value( const math_Vector & X,math_Vector & F) override { using return_type = Standard_Boolean;
    PYBIND11_OVERLOAD_PURE(return_type,Blend_CSFunction,Value,X,F) };
        Standard_Boolean Derivatives( const math_Vector & X,math_Matrix & D) override { using return_type = Standard_Boolean;
    PYBIND11_OVERLOAD_PURE(return_type,Blend_CSFunction,Derivatives,X,D) };
        Standard_Boolean Values( const math_Vector & X,math_Vector & F,math_Matrix & D) override { using return_type = Standard_Boolean;
    PYBIND11_OVERLOAD_PURE(return_type,Blend_CSFunction,Values,X,F,D) };
        void Set( const Standard_Real Param) override { using return_type = void;
    PYBIND11_OVERLOAD_PURE(return_type,Blend_CSFunction,Set,Param) };
        void Set( const Standard_Real First, const Standard_Real Last) override { using return_type = void;
    PYBIND11_OVERLOAD_PURE(return_type,Blend_CSFunction,Set,First,Last) };
        void GetTolerance(math_Vector & Tolerance, const Standard_Real Tol) const  override { using return_type = void;
    PYBIND11_OVERLOAD_PURE(return_type,Blend_CSFunction,GetTolerance,Tolerance,Tol) };
        void GetBounds(math_Vector & InfBound,math_Vector & SupBound) const  override { using return_type = void;
    PYBIND11_OVERLOAD_PURE(return_type,Blend_CSFunction,GetBounds,InfBound,SupBound) };
        Standard_Boolean IsSolution( const math_Vector & Sol, const Standard_Real Tol) override { using return_type = Standard_Boolean;
    PYBIND11_OVERLOAD_PURE(return_type,Blend_CSFunction,IsSolution,Sol,Tol) };
         const gp_Pnt & PointOnS() const  override { using return_type =  const gp_Pnt &;
    PYBIND11_OVERLOAD_PURE(return_type,Blend_CSFunction,PointOnS,) };
         const gp_Pnt & PointOnC() const  override { using return_type =  const gp_Pnt &;
    PYBIND11_OVERLOAD_PURE(return_type,Blend_CSFunction,PointOnC,) };
         const gp_Pnt2d & Pnt2d() const  override { using return_type =  const gp_Pnt2d &;
    PYBIND11_OVERLOAD_PURE(return_type,Blend_CSFunction,Pnt2d,) };
        Standard_Real ParameterOnC() const  override { using return_type = Standard_Real;
    PYBIND11_OVERLOAD_PURE(return_type,Blend_CSFunction,ParameterOnC,) };
        Standard_Boolean IsTangencyPoint() const  override { using return_type = Standard_Boolean;
    PYBIND11_OVERLOAD_PURE(return_type,Blend_CSFunction,IsTangencyPoint,) };
         const gp_Vec & TangentOnS() const  override { using return_type =  const gp_Vec &;
    PYBIND11_OVERLOAD_PURE(return_type,Blend_CSFunction,TangentOnS,) };
         const gp_Vec2d & Tangent2d() const  override { using return_type =  const gp_Vec2d &;
    PYBIND11_OVERLOAD_PURE(return_type,Blend_CSFunction,Tangent2d,) };
         const gp_Vec & TangentOnC() const  override { using return_type =  const gp_Vec &;
    PYBIND11_OVERLOAD_PURE(return_type,Blend_CSFunction,TangentOnC,) };
        void Tangent( const Standard_Real U, const Standard_Real V,gp_Vec & TgS,gp_Vec & NormS) const  override { using return_type = void;
    PYBIND11_OVERLOAD_PURE(return_type,Blend_CSFunction,Tangent,U,V,TgS,NormS) };
        void GetTolerance( const Standard_Real BoundTol, const Standard_Real SurfTol, const Standard_Real AngleTol,math_Vector & Tol3d,math_Vector & Tol1D) const  override { using return_type = void;
    PYBIND11_OVERLOAD_PURE(return_type,Blend_CSFunction,GetTolerance,BoundTol,SurfTol,AngleTol,Tol3d,Tol1D) };
        void Knots(TColStd_Array1OfReal & TKnots) override { using return_type = void;
    PYBIND11_OVERLOAD_PURE(return_type,Blend_CSFunction,Knots,TKnots) };
        void Mults(TColStd_Array1OfInteger & TMults) override { using return_type = void;
    PYBIND11_OVERLOAD_PURE(return_type,Blend_CSFunction,Mults,TMults) };
        Standard_Boolean Section( const Blend_Point & P,TColgp_Array1OfPnt & Poles,TColgp_Array1OfVec & DPoles,TColgp_Array1OfPnt2d & Poles2d,TColgp_Array1OfVec2d & DPoles2d,TColStd_Array1OfReal & Weigths,TColStd_Array1OfReal & DWeigths) override { using return_type = Standard_Boolean;
    PYBIND11_OVERLOAD_PURE(return_type,Blend_CSFunction,Section,P,Poles,DPoles,Poles2d,DPoles2d,Weigths,DWeigths) };
        void Section( const Blend_Point & P,TColgp_Array1OfPnt & Poles,TColgp_Array1OfPnt2d & Poles2d,TColStd_Array1OfReal & Weigths) override { using return_type = void;
    PYBIND11_OVERLOAD_PURE(return_type,Blend_CSFunction,Section,P,Poles,Poles2d,Weigths) };
        void GetShape(Standard_Integer & NbPoles,Standard_Integer & NbKnots,Standard_Integer & Degree,Standard_Integer & NbPoles2d) override { using return_type = void;
    PYBIND11_OVERLOAD_PURE(return_type,Blend_CSFunction,GetShape,NbPoles,NbKnots,Degree,NbPoles2d) };

        Standard_Boolean IsRational() const  override { using return_type = Standard_Boolean;
    PYBIND11_OVERLOAD_PURE(return_type,Blend_AppFunction,IsRational,) };
        Standard_Real GetSectionSize() const  override { using return_type = Standard_Real;
    PYBIND11_OVERLOAD_PURE(return_type,Blend_AppFunction,GetSectionSize,) };
        void GetMinimalWeight(TColStd_Array1OfReal & Weigths) const  override { using return_type = void;
    PYBIND11_OVERLOAD_PURE(return_type,Blend_AppFunction,GetMinimalWeight,Weigths) };
        Standard_Integer NbIntervals( const GeomAbs_Shape S) const  override { using return_type = Standard_Integer;
    PYBIND11_OVERLOAD_PURE(return_type,Blend_AppFunction,NbIntervals,S) };
        void Intervals(TColStd_Array1OfReal & T, const GeomAbs_Shape S) const  override { using return_type = void;
    PYBIND11_OVERLOAD_PURE(return_type,Blend_AppFunction,Intervals,T,S) };

        // protected pure virtual


        // private pure virtual

    };
    class Py_Blend_Function : public Blend_Function{
    public:
        using Blend_Function::Blend_Function;


        // public pure virtual
         const gp_Pnt & PointOnS1() const  override { using return_type =  const gp_Pnt &;
    PYBIND11_OVERLOAD_PURE(return_type,Blend_Function,PointOnS1,) };
         const gp_Pnt & PointOnS2() const  override { using return_type =  const gp_Pnt &;
    PYBIND11_OVERLOAD_PURE(return_type,Blend_Function,PointOnS2,) };
        Standard_Boolean IsTangencyPoint() const  override { using return_type = Standard_Boolean;
    PYBIND11_OVERLOAD_PURE(return_type,Blend_Function,IsTangencyPoint,) };
         const gp_Vec & TangentOnS1() const  override { using return_type =  const gp_Vec &;
    PYBIND11_OVERLOAD_PURE(return_type,Blend_Function,TangentOnS1,) };
         const gp_Vec2d & Tangent2dOnS1() const  override { using return_type =  const gp_Vec2d &;
    PYBIND11_OVERLOAD_PURE(return_type,Blend_Function,Tangent2dOnS1,) };
         const gp_Vec & TangentOnS2() const  override { using return_type =  const gp_Vec &;
    PYBIND11_OVERLOAD_PURE(return_type,Blend_Function,TangentOnS2,) };
         const gp_Vec2d & Tangent2dOnS2() const  override { using return_type =  const gp_Vec2d &;
    PYBIND11_OVERLOAD_PURE(return_type,Blend_Function,Tangent2dOnS2,) };
        void Tangent( const Standard_Real U1, const Standard_Real V1, const Standard_Real U2, const Standard_Real V2,gp_Vec & TgFirst,gp_Vec & TgLast,gp_Vec & NormFirst,gp_Vec & NormLast) const  override { using return_type = void;
    PYBIND11_OVERLOAD_PURE(return_type,Blend_Function,Tangent,U1,V1,U2,V2,TgFirst,TgLast,NormFirst,NormLast) };
        void Section( const Blend_Point & P,TColgp_Array1OfPnt & Poles,TColgp_Array1OfPnt2d & Poles2d,TColStd_Array1OfReal & Weigths) override { using return_type = void;
    PYBIND11_OVERLOAD_PURE(return_type,Blend_Function,Section,P,Poles,Poles2d,Weigths) };

        Standard_Integer NbEquations() const  override { using return_type = Standard_Integer;
    PYBIND11_OVERLOAD_PURE(return_type,Blend_AppFunction,NbEquations,) };
        Standard_Boolean Value( const math_Vector & X,math_Vector & F) override { using return_type = Standard_Boolean;
    PYBIND11_OVERLOAD_PURE(return_type,Blend_AppFunction,Value,X,F) };
        Standard_Boolean Derivatives( const math_Vector & X,math_Matrix & D) override { using return_type = Standard_Boolean;
    PYBIND11_OVERLOAD_PURE(return_type,Blend_AppFunction,Derivatives,X,D) };
        Standard_Boolean Values( const math_Vector & X,math_Vector & F,math_Matrix & D) override { using return_type = Standard_Boolean;
    PYBIND11_OVERLOAD_PURE(return_type,Blend_AppFunction,Values,X,F,D) };
        void Set( const Standard_Real Param) override { using return_type = void;
    PYBIND11_OVERLOAD_PURE(return_type,Blend_AppFunction,Set,Param) };
        void Set( const Standard_Real First, const Standard_Real Last) override { using return_type = void;
    PYBIND11_OVERLOAD_PURE(return_type,Blend_AppFunction,Set,First,Last) };
        void GetTolerance(math_Vector & Tolerance, const Standard_Real Tol) const  override { using return_type = void;
    PYBIND11_OVERLOAD_PURE(return_type,Blend_AppFunction,GetTolerance,Tolerance,Tol) };
        void GetBounds(math_Vector & InfBound,math_Vector & SupBound) const  override { using return_type = void;
    PYBIND11_OVERLOAD_PURE(return_type,Blend_AppFunction,GetBounds,InfBound,SupBound) };
        Standard_Boolean IsSolution( const math_Vector & Sol, const Standard_Real Tol) override { using return_type = Standard_Boolean;
    PYBIND11_OVERLOAD_PURE(return_type,Blend_AppFunction,IsSolution,Sol,Tol) };
        Standard_Real GetMinimalDistance() const  override { using return_type = Standard_Real;
    PYBIND11_OVERLOAD_PURE(return_type,Blend_AppFunction,GetMinimalDistance,) };
        Standard_Boolean IsRational() const  override { using return_type = Standard_Boolean;
    PYBIND11_OVERLOAD_PURE(return_type,Blend_AppFunction,IsRational,) };
        Standard_Real GetSectionSize() const  override { using return_type = Standard_Real;
    PYBIND11_OVERLOAD_PURE(return_type,Blend_AppFunction,GetSectionSize,) };
        void GetMinimalWeight(TColStd_Array1OfReal & Weigths) const  override { using return_type = void;
    PYBIND11_OVERLOAD_PURE(return_type,Blend_AppFunction,GetMinimalWeight,Weigths) };
        Standard_Integer NbIntervals( const GeomAbs_Shape S) const  override { using return_type = Standard_Integer;
    PYBIND11_OVERLOAD_PURE(return_type,Blend_AppFunction,NbIntervals,S) };
        void Intervals(TColStd_Array1OfReal & T, const GeomAbs_Shape S) const  override { using return_type = void;
    PYBIND11_OVERLOAD_PURE(return_type,Blend_AppFunction,Intervals,T,S) };
        void GetTolerance( const Standard_Real BoundTol, const Standard_Real SurfTol, const Standard_Real AngleTol,math_Vector & Tol3d,math_Vector & Tol1D) const  override { using return_type = void;
    PYBIND11_OVERLOAD_PURE(return_type,Blend_AppFunction,GetTolerance,BoundTol,SurfTol,AngleTol,Tol3d,Tol1D) };
        void Knots(TColStd_Array1OfReal & TKnots) override { using return_type = void;
    PYBIND11_OVERLOAD_PURE(return_type,Blend_AppFunction,Knots,TKnots) };
        void Mults(TColStd_Array1OfInteger & TMults) override { using return_type = void;
    PYBIND11_OVERLOAD_PURE(return_type,Blend_AppFunction,Mults,TMults) };

        // protected pure virtual


        // private pure virtual

    };
    class Py_Blend_RstRstFunction : public Blend_RstRstFunction{
    public:
        using Blend_RstRstFunction::Blend_RstRstFunction;


        // public pure virtual
        Standard_Integer NbVariables() const  override { using return_type = Standard_Integer;
    PYBIND11_OVERLOAD_PURE(return_type,Blend_RstRstFunction,NbVariables,) };
        Standard_Integer NbEquations() const  override { using return_type = Standard_Integer;
    PYBIND11_OVERLOAD_PURE(return_type,Blend_RstRstFunction,NbEquations,) };
        Standard_Boolean Value( const math_Vector & X,math_Vector & F) override { using return_type = Standard_Boolean;
    PYBIND11_OVERLOAD_PURE(return_type,Blend_RstRstFunction,Value,X,F) };
        Standard_Boolean Derivatives( const math_Vector & X,math_Matrix & D) override { using return_type = Standard_Boolean;
    PYBIND11_OVERLOAD_PURE(return_type,Blend_RstRstFunction,Derivatives,X,D) };
        Standard_Boolean Values( const math_Vector & X,math_Vector & F,math_Matrix & D) override { using return_type = Standard_Boolean;
    PYBIND11_OVERLOAD_PURE(return_type,Blend_RstRstFunction,Values,X,F,D) };
        void Set( const Standard_Real Param) override { using return_type = void;
    PYBIND11_OVERLOAD_PURE(return_type,Blend_RstRstFunction,Set,Param) };
        void Set( const Standard_Real First, const Standard_Real Last) override { using return_type = void;
    PYBIND11_OVERLOAD_PURE(return_type,Blend_RstRstFunction,Set,First,Last) };
        void GetTolerance(math_Vector & Tolerance, const Standard_Real Tol) const  override { using return_type = void;
    PYBIND11_OVERLOAD_PURE(return_type,Blend_RstRstFunction,GetTolerance,Tolerance,Tol) };
        void GetBounds(math_Vector & InfBound,math_Vector & SupBound) const  override { using return_type = void;
    PYBIND11_OVERLOAD_PURE(return_type,Blend_RstRstFunction,GetBounds,InfBound,SupBound) };
        Standard_Boolean IsSolution( const math_Vector & Sol, const Standard_Real Tol) override { using return_type = Standard_Boolean;
    PYBIND11_OVERLOAD_PURE(return_type,Blend_RstRstFunction,IsSolution,Sol,Tol) };
         const gp_Pnt & PointOnRst1() const  override { using return_type =  const gp_Pnt &;
    PYBIND11_OVERLOAD_PURE(return_type,Blend_RstRstFunction,PointOnRst1,) };
         const gp_Pnt & PointOnRst2() const  override { using return_type =  const gp_Pnt &;
    PYBIND11_OVERLOAD_PURE(return_type,Blend_RstRstFunction,PointOnRst2,) };
         const gp_Pnt2d & Pnt2dOnRst1() const  override { using return_type =  const gp_Pnt2d &;
    PYBIND11_OVERLOAD_PURE(return_type,Blend_RstRstFunction,Pnt2dOnRst1,) };
         const gp_Pnt2d & Pnt2dOnRst2() const  override { using return_type =  const gp_Pnt2d &;
    PYBIND11_OVERLOAD_PURE(return_type,Blend_RstRstFunction,Pnt2dOnRst2,) };
        Standard_Real ParameterOnRst1() const  override { using return_type = Standard_Real;
    PYBIND11_OVERLOAD_PURE(return_type,Blend_RstRstFunction,ParameterOnRst1,) };
        Standard_Real ParameterOnRst2() const  override { using return_type = Standard_Real;
    PYBIND11_OVERLOAD_PURE(return_type,Blend_RstRstFunction,ParameterOnRst2,) };
        Standard_Boolean IsTangencyPoint() const  override { using return_type = Standard_Boolean;
    PYBIND11_OVERLOAD_PURE(return_type,Blend_RstRstFunction,IsTangencyPoint,) };
         const gp_Vec & TangentOnRst1() const  override { using return_type =  const gp_Vec &;
    PYBIND11_OVERLOAD_PURE(return_type,Blend_RstRstFunction,TangentOnRst1,) };
         const gp_Vec2d & Tangent2dOnRst1() const  override { using return_type =  const gp_Vec2d &;
    PYBIND11_OVERLOAD_PURE(return_type,Blend_RstRstFunction,Tangent2dOnRst1,) };
         const gp_Vec & TangentOnRst2() const  override { using return_type =  const gp_Vec &;
    PYBIND11_OVERLOAD_PURE(return_type,Blend_RstRstFunction,TangentOnRst2,) };
         const gp_Vec2d & Tangent2dOnRst2() const  override { using return_type =  const gp_Vec2d &;
    PYBIND11_OVERLOAD_PURE(return_type,Blend_RstRstFunction,Tangent2dOnRst2,) };
        Blend_DecrochStatus Decroch( const math_Vector & Sol,gp_Vec & NRst1,gp_Vec & TgRst1,gp_Vec & NRst2,gp_Vec & TgRst2) const  override { using return_type = Blend_DecrochStatus;
    PYBIND11_OVERLOAD_PURE(return_type,Blend_RstRstFunction,Decroch,Sol,NRst1,TgRst1,NRst2,TgRst2) };
        Standard_Boolean IsRational() const  override { using return_type = Standard_Boolean;
    PYBIND11_OVERLOAD_PURE(return_type,Blend_RstRstFunction,IsRational,) };
        Standard_Real GetSectionSize() const  override { using return_type = Standard_Real;
    PYBIND11_OVERLOAD_PURE(return_type,Blend_RstRstFunction,GetSectionSize,) };
        void GetMinimalWeight(TColStd_Array1OfReal & Weigths) const  override { using return_type = void;
    PYBIND11_OVERLOAD_PURE(return_type,Blend_RstRstFunction,GetMinimalWeight,Weigths) };
        Standard_Integer NbIntervals( const GeomAbs_Shape S) const  override { using return_type = Standard_Integer;
    PYBIND11_OVERLOAD_PURE(return_type,Blend_RstRstFunction,NbIntervals,S) };
        void Intervals(TColStd_Array1OfReal & T, const GeomAbs_Shape S) const  override { using return_type = void;
    PYBIND11_OVERLOAD_PURE(return_type,Blend_RstRstFunction,Intervals,T,S) };
        void GetTolerance( const Standard_Real BoundTol, const Standard_Real SurfTol, const Standard_Real AngleTol,math_Vector & Tol3d,math_Vector & Tol1D) const  override { using return_type = void;
    PYBIND11_OVERLOAD_PURE(return_type,Blend_RstRstFunction,GetTolerance,BoundTol,SurfTol,AngleTol,Tol3d,Tol1D) };
        void Knots(TColStd_Array1OfReal & TKnots) override { using return_type = void;
    PYBIND11_OVERLOAD_PURE(return_type,Blend_RstRstFunction,Knots,TKnots) };
        void Mults(TColStd_Array1OfInteger & TMults) override { using return_type = void;
    PYBIND11_OVERLOAD_PURE(return_type,Blend_RstRstFunction,Mults,TMults) };
        void Section( const Blend_Point & P,TColgp_Array1OfPnt & Poles,TColgp_Array1OfPnt2d & Poles2d,TColStd_Array1OfReal & Weigths) override { using return_type = void;
    PYBIND11_OVERLOAD_PURE(return_type,Blend_RstRstFunction,Section,P,Poles,Poles2d,Weigths) };
        Standard_Boolean Section( const Blend_Point & P,TColgp_Array1OfPnt & Poles,TColgp_Array1OfVec & DPoles,TColgp_Array1OfPnt2d & Poles2d,TColgp_Array1OfVec2d & DPoles2d,TColStd_Array1OfReal & Weigths,TColStd_Array1OfReal & DWeigths) override { using return_type = Standard_Boolean;
    PYBIND11_OVERLOAD_PURE(return_type,Blend_RstRstFunction,Section,P,Poles,DPoles,Poles2d,DPoles2d,Weigths,DWeigths) };
        Standard_Boolean Section( const Blend_Point & P,TColgp_Array1OfPnt & Poles,TColgp_Array1OfVec & DPoles,TColgp_Array1OfVec & D2Poles,TColgp_Array1OfPnt2d & Poles2d,TColgp_Array1OfVec2d & DPoles2d,TColgp_Array1OfVec2d & D2Poles2d,TColStd_Array1OfReal & Weigths,TColStd_Array1OfReal & DWeigths,TColStd_Array1OfReal & D2Weigths) override { using return_type = Standard_Boolean;
    PYBIND11_OVERLOAD_PURE(return_type,Blend_RstRstFunction,Section,P,Poles,DPoles,D2Poles,Poles2d,DPoles2d,D2Poles2d,Weigths,DWeigths,D2Weigths) };
        void GetShape(Standard_Integer & NbPoles,Standard_Integer & NbKnots,Standard_Integer & Degree,Standard_Integer & NbPoles2d) override { using return_type = void;
    PYBIND11_OVERLOAD_PURE(return_type,Blend_RstRstFunction,GetShape,NbPoles,NbKnots,Degree,NbPoles2d) };


        // protected pure virtual


        // private pure virtual

    };
    class Py_Blend_SurfRstFunction : public Blend_SurfRstFunction{
    public:
        using Blend_SurfRstFunction::Blend_SurfRstFunction;


        // public pure virtual
        Standard_Integer NbVariables() const  override { using return_type = Standard_Integer;
    PYBIND11_OVERLOAD_PURE(return_type,Blend_SurfRstFunction,NbVariables,) };
        Standard_Integer NbEquations() const  override { using return_type = Standard_Integer;
    PYBIND11_OVERLOAD_PURE(return_type,Blend_SurfRstFunction,NbEquations,) };
        Standard_Boolean Value( const math_Vector & X,math_Vector & F) override { using return_type = Standard_Boolean;
    PYBIND11_OVERLOAD_PURE(return_type,Blend_SurfRstFunction,Value,X,F) };
        Standard_Boolean Derivatives( const math_Vector & X,math_Matrix & D) override { using return_type = Standard_Boolean;
    PYBIND11_OVERLOAD_PURE(return_type,Blend_SurfRstFunction,Derivatives,X,D) };
        Standard_Boolean Values( const math_Vector & X,math_Vector & F,math_Matrix & D) override { using return_type = Standard_Boolean;
    PYBIND11_OVERLOAD_PURE(return_type,Blend_SurfRstFunction,Values,X,F,D) };
        void Set( const Standard_Real Param) override { using return_type = void;
    PYBIND11_OVERLOAD_PURE(return_type,Blend_SurfRstFunction,Set,Param) };
        void Set( const Standard_Real First, const Standard_Real Last) override { using return_type = void;
    PYBIND11_OVERLOAD_PURE(return_type,Blend_SurfRstFunction,Set,First,Last) };
        void GetTolerance(math_Vector & Tolerance, const Standard_Real Tol) const  override { using return_type = void;
    PYBIND11_OVERLOAD_PURE(return_type,Blend_SurfRstFunction,GetTolerance,Tolerance,Tol) };
        void GetBounds(math_Vector & InfBound,math_Vector & SupBound) const  override { using return_type = void;
    PYBIND11_OVERLOAD_PURE(return_type,Blend_SurfRstFunction,GetBounds,InfBound,SupBound) };
        Standard_Boolean IsSolution( const math_Vector & Sol, const Standard_Real Tol) override { using return_type = Standard_Boolean;
    PYBIND11_OVERLOAD_PURE(return_type,Blend_SurfRstFunction,IsSolution,Sol,Tol) };
         const gp_Pnt & PointOnS() const  override { using return_type =  const gp_Pnt &;
    PYBIND11_OVERLOAD_PURE(return_type,Blend_SurfRstFunction,PointOnS,) };
         const gp_Pnt & PointOnRst() const  override { using return_type =  const gp_Pnt &;
    PYBIND11_OVERLOAD_PURE(return_type,Blend_SurfRstFunction,PointOnRst,) };
         const gp_Pnt2d & Pnt2dOnS() const  override { using return_type =  const gp_Pnt2d &;
    PYBIND11_OVERLOAD_PURE(return_type,Blend_SurfRstFunction,Pnt2dOnS,) };
         const gp_Pnt2d & Pnt2dOnRst() const  override { using return_type =  const gp_Pnt2d &;
    PYBIND11_OVERLOAD_PURE(return_type,Blend_SurfRstFunction,Pnt2dOnRst,) };
        Standard_Real ParameterOnRst() const  override { using return_type = Standard_Real;
    PYBIND11_OVERLOAD_PURE(return_type,Blend_SurfRstFunction,ParameterOnRst,) };
        Standard_Boolean IsTangencyPoint() const  override { using return_type = Standard_Boolean;
    PYBIND11_OVERLOAD_PURE(return_type,Blend_SurfRstFunction,IsTangencyPoint,) };
         const gp_Vec & TangentOnS() const  override { using return_type =  const gp_Vec &;
    PYBIND11_OVERLOAD_PURE(return_type,Blend_SurfRstFunction,TangentOnS,) };
         const gp_Vec2d & Tangent2dOnS() const  override { using return_type =  const gp_Vec2d &;
    PYBIND11_OVERLOAD_PURE(return_type,Blend_SurfRstFunction,Tangent2dOnS,) };
         const gp_Vec & TangentOnRst() const  override { using return_type =  const gp_Vec &;
    PYBIND11_OVERLOAD_PURE(return_type,Blend_SurfRstFunction,TangentOnRst,) };
         const gp_Vec2d & Tangent2dOnRst() const  override { using return_type =  const gp_Vec2d &;
    PYBIND11_OVERLOAD_PURE(return_type,Blend_SurfRstFunction,Tangent2dOnRst,) };
        Standard_Boolean Decroch( const math_Vector & Sol,gp_Vec & NS,gp_Vec & TgS) const  override { using return_type = Standard_Boolean;
    PYBIND11_OVERLOAD_PURE(return_type,Blend_SurfRstFunction,Decroch,Sol,NS,TgS) };
        Standard_Boolean IsRational() const  override { using return_type = Standard_Boolean;
    PYBIND11_OVERLOAD_PURE(return_type,Blend_SurfRstFunction,IsRational,) };
        Standard_Real GetSectionSize() const  override { using return_type = Standard_Real;
    PYBIND11_OVERLOAD_PURE(return_type,Blend_SurfRstFunction,GetSectionSize,) };
        void GetMinimalWeight(TColStd_Array1OfReal & Weigths) const  override { using return_type = void;
    PYBIND11_OVERLOAD_PURE(return_type,Blend_SurfRstFunction,GetMinimalWeight,Weigths) };
        Standard_Integer NbIntervals( const GeomAbs_Shape S) const  override { using return_type = Standard_Integer;
    PYBIND11_OVERLOAD_PURE(return_type,Blend_SurfRstFunction,NbIntervals,S) };
        void Intervals(TColStd_Array1OfReal & T, const GeomAbs_Shape S) const  override { using return_type = void;
    PYBIND11_OVERLOAD_PURE(return_type,Blend_SurfRstFunction,Intervals,T,S) };
        void GetTolerance( const Standard_Real BoundTol, const Standard_Real SurfTol, const Standard_Real AngleTol,math_Vector & Tol3d,math_Vector & Tol1D) const  override { using return_type = void;
    PYBIND11_OVERLOAD_PURE(return_type,Blend_SurfRstFunction,GetTolerance,BoundTol,SurfTol,AngleTol,Tol3d,Tol1D) };
        void Knots(TColStd_Array1OfReal & TKnots) override { using return_type = void;
    PYBIND11_OVERLOAD_PURE(return_type,Blend_SurfRstFunction,Knots,TKnots) };
        void Mults(TColStd_Array1OfInteger & TMults) override { using return_type = void;
    PYBIND11_OVERLOAD_PURE(return_type,Blend_SurfRstFunction,Mults,TMults) };
        Standard_Boolean Section( const Blend_Point & P,TColgp_Array1OfPnt & Poles,TColgp_Array1OfVec & DPoles,TColgp_Array1OfPnt2d & Poles2d,TColgp_Array1OfVec2d & DPoles2d,TColStd_Array1OfReal & Weigths,TColStd_Array1OfReal & DWeigths) override { using return_type = Standard_Boolean;
    PYBIND11_OVERLOAD_PURE(return_type,Blend_SurfRstFunction,Section,P,Poles,DPoles,Poles2d,DPoles2d,Weigths,DWeigths) };
        Standard_Boolean Section( const Blend_Point & P,TColgp_Array1OfPnt & Poles,TColgp_Array1OfVec & DPoles,TColgp_Array1OfVec & D2Poles,TColgp_Array1OfPnt2d & Poles2d,TColgp_Array1OfVec2d & DPoles2d,TColgp_Array1OfVec2d & D2Poles2d,TColStd_Array1OfReal & Weigths,TColStd_Array1OfReal & DWeigths,TColStd_Array1OfReal & D2Weigths) override { using return_type = Standard_Boolean;
    PYBIND11_OVERLOAD_PURE(return_type,Blend_SurfRstFunction,Section,P,Poles,DPoles,D2Poles,Poles2d,DPoles2d,D2Poles2d,Weigths,DWeigths,D2Weigths) };
        void Section( const Blend_Point & P,TColgp_Array1OfPnt & Poles,TColgp_Array1OfPnt2d & Poles2d,TColStd_Array1OfReal & Weigths) override { using return_type = void;
    PYBIND11_OVERLOAD_PURE(return_type,Blend_SurfRstFunction,Section,P,Poles,Poles2d,Weigths) };
        void GetShape(Standard_Integer & NbPoles,Standard_Integer & NbKnots,Standard_Integer & Degree,Standard_Integer & NbPoles2d) override { using return_type = void;
    PYBIND11_OVERLOAD_PURE(return_type,Blend_SurfRstFunction,GetShape,NbPoles,NbKnots,Degree,NbPoles2d) };


        // protected pure virtual


        // private pure virtual

    };

// pre-register typdefs+classes (topologically sorted)
    py::class_<Blend_Point , shared_ptr<Blend_Point>  >(m,"Blend_Point",R"#()#");
    py::class_<Blend_AppFunction , shared_ptr<Blend_AppFunction> ,Py_Blend_AppFunction , math_FunctionSetWithDerivatives >(m,"Blend_AppFunction",R"#(Deferred class for a function used to compute a blending surface between two surfaces, using a guide line. The vector <X> used in Value, Values and Derivatives methods has to be the vector of the parametric coordinates U1,V1, U2,V2, of the extremities of a section on the first and second surface.)#");
    py::class_<Blend_CurvPointFuncInv , shared_ptr<Blend_CurvPointFuncInv> ,Py_Blend_CurvPointFuncInv , math_FunctionSetWithDerivatives >(m,"Blend_CurvPointFuncInv",R"#(Deferred class for a function used to compute a blending surface between a surface and a curve, using a guide line. This function is used to find a solution on a done point of the curve. The vector <X> used in Value, Values and Derivatives methods has to be the vector of the parametric coordinates w, U, V where w is the parameter on the guide line, U,V are the parametric coordinates of a point on the partner surface.)#");
    py::class_<Blend_FuncInv , shared_ptr<Blend_FuncInv> ,Py_Blend_FuncInv , math_FunctionSetWithDerivatives >(m,"Blend_FuncInv",R"#(Deferred class for a function used to compute a blending surface between two surfaces, using a guide line. This function is used to find a solution on a restriction of one of the surface. The vector <X> used in Value, Values and Derivatives methods has to be the vector of the parametric coordinates t,w,U,V where t is the parameter on the curve on surface, w is the parameter on the guide line, U,V are the parametric coordinates of a point on the partner surface.)#");
    preregister_template_NCollection_Sequence<Blend_Point>(m,"Blend_SequenceOfPoint");
    py::class_<Blend_SurfCurvFuncInv , shared_ptr<Blend_SurfCurvFuncInv> ,Py_Blend_SurfCurvFuncInv , math_FunctionSetWithDerivatives >(m,"Blend_SurfCurvFuncInv",R"#(Deferred class for a function used to compute a blending surface between a surface and a curve, using a guide line. This function is used to find a solution on a done restriction of the surface.)#");
    py::class_<Blend_SurfPointFuncInv , shared_ptr<Blend_SurfPointFuncInv> ,Py_Blend_SurfPointFuncInv , math_FunctionSetWithDerivatives >(m,"Blend_SurfPointFuncInv",R"#(Deferred class for a function used to compute a blending surface between a surface and a curve, using a guide line. This function is used to find a solution on a done point of the curve.)#");
    py::class_<Blend_CSFunction , shared_ptr<Blend_CSFunction> ,Py_Blend_CSFunction , Blend_AppFunction >(m,"Blend_CSFunction",R"#(Deferred class for a function used to compute a blending surface between a surface and a curve, using a guide line. The vector <X> used in Value, Values and Derivatives methods may be the vector of the parametric coordinates U,V, W of the extremities of a section on the surface and the curve.)#");
    py::class_<Blend_Function , shared_ptr<Blend_Function> ,Py_Blend_Function , Blend_AppFunction >(m,"Blend_Function",R"#(Deferred class for a function used to compute a blending surface between two surfaces, using a guide line. The vector <X> used in Value, Values and Derivatives methods has to be the vector of the parametric coordinates U1,V1, U2,V2, of the extremities of a section on the first and second surface.)#");
    py::class_<Blend_RstRstFunction , shared_ptr<Blend_RstRstFunction> ,Py_Blend_RstRstFunction , Blend_AppFunction >(m,"Blend_RstRstFunction",R"#(Deferred class for a function used to compute a blending surface between a surface and a pcurve on an other Surface, using a guide line. The vector <X> used in Value, Values and Derivatives methods may be the vector of the parametric coordinates U,V, W of the extremities of a section on the surface and the curve.)#");
    py::class_<Blend_SurfRstFunction , shared_ptr<Blend_SurfRstFunction> ,Py_Blend_SurfRstFunction , Blend_AppFunction >(m,"Blend_SurfRstFunction",R"#(Deferred class for a function used to compute a blending surface between a surface and a pcurve on an other Surface, using a guide line. The vector <X> used in Value, Values and Derivatives methods may be the vector of the parametric coordinates U,V, W of the extremities of a section on the surface and the curve.)#");

};

// user-defined post-inclusion per module

// user-defined post
